/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.init;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ParticleInit {
    public static final SimpleParticleType AMETHYST_SHARD_PARTICLE = FabricParticleTypes.simple();
    public static final SimpleParticleType VOID_CLOUD_PARTICLE = FabricParticleTypes.simple();
    public static final SimpleParticleType SPRINT_PARTICLE = FabricParticleTypes.simple();

    public static void init() {
        Registry.m_122965_((Registry)BuiltInRegistries.f_257034_, (ResourceLocation)new ResourceLocation("adventurez", "amethyst_shard_particle"), (Object)AMETHYST_SHARD_PARTICLE);
        Registry.m_122965_((Registry)BuiltInRegistries.f_257034_, (ResourceLocation)new ResourceLocation("adventurez", "void_cloud_particle"), (Object)VOID_CLOUD_PARTICLE);
        Registry.m_122965_((Registry)BuiltInRegistries.f_257034_, (ResourceLocation)new ResourceLocation("adventurez", "sprint_particle"), (Object)SPRINT_PARTICLE);
    }

    @Environment(value=EnvType.CLIENT)
    static class SprintParticle
    extends TextureSheetParticle {
        static final Random RANDOM = new Random();
        private final SpriteSet spriteProvider;

        public SprintParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, SpriteSet spriteProvider) {
            super(clientWorld, d, e, f);
            this.f_172258_ = 1.0f;
            this.f_172259_ = false;
            this.f_107226_ = 0.0f;
            this.spriteProvider = spriteProvider;
            this.f_107219_ = false;
            this.m_108339_(spriteProvider);
        }

        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107431_;
        }

        public void m_5989_() {
            super.m_5989_();
            this.m_108339_(this.spriteProvider);
        }

        @Environment(value=EnvType.CLIENT)
        public static class SprintFactory
        implements ParticleProvider<SimpleParticleType> {
            private final SpriteSet spriteProvider;

            public SprintFactory(FabricSpriteProvider sprites) {
                this.spriteProvider = sprites;
            }

            public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
                SprintParticle sprintParticle = new SprintParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
                sprintParticle.f_107215_ = -g * 1.5;
                sprintParticle.f_107217_ = -i * 1.5;
                sprintParticle.m_107257_(8);
                return sprintParticle;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class VoidCloudParticle
    extends TextureSheetParticle {
        private final double startX;
        private final double startY;
        private final double startZ;

        private VoidCloudParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            super(clientWorld, d, e, f);
            this.f_107215_ = g;
            this.f_107216_ = h;
            this.f_107217_ = i;
            this.f_107212_ = d;
            this.f_107213_ = e;
            this.f_107214_ = f;
            this.startX = this.f_107212_;
            this.startY = this.f_107213_;
            this.startZ = this.f_107214_;
            this.f_107663_ = 0.5f * (this.f_107223_.m_188501_() * 0.05f + 0.4f);
            this.f_107227_ = this.f_107223_.m_188501_() * 0.2f;
            this.f_107228_ = this.f_107223_.m_188501_() * 0.2f;
            this.f_107229_ = this.f_107223_.m_188501_() * 0.2f;
            this.f_107225_ = (int)(this.f_107223_.m_188501_() * 2.0f) + 10;
        }

        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107430_;
        }

        public void m_6257_(double dx, double dy, double dz) {
            this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
            this.m_107275_();
        }

        public float m_5902_(float tickDelta) {
            float f = ((float)this.f_107224_ + tickDelta) / (float)this.f_107225_;
            f = 1.0f - f;
            f *= f;
            f = 1.0f - f;
            return this.f_107663_ * f;
        }

        public int m_6355_(float tint) {
            int i = super.m_6355_(tint);
            float f = (float)this.f_107224_ / (float)this.f_107225_;
            f *= f;
            f *= f;
            int j = i & 0xFF;
            int k = i >> 16 & 0xFF;
            if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
                k = 240;
            }
            return j | k << 16;
        }

        public void m_5989_() {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            if (this.f_107224_++ >= this.f_107225_) {
                this.m_107274_();
            } else {
                float f;
                float g = f = (float)this.f_107224_ / (float)this.f_107225_;
                f = -f + f * f * 2.0f;
                f = 1.0f - f;
                this.f_107212_ = this.startX + this.f_107215_ * (double)f;
                this.f_107213_ = this.startY + this.f_107216_ * (double)f + (double)(1.0f - g);
                this.f_107214_ = this.startZ + this.f_107217_ * (double)f;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static class CloudFactory
        implements ParticleProvider<SimpleParticleType> {
            private final SpriteSet spriteProvider;

            public CloudFactory(SpriteSet spriteProvider) {
                this.spriteProvider = spriteProvider;
            }

            public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
                VoidCloudParticle portalParticle = new VoidCloudParticle(clientWorld, d, e, f, g, h, i);
                portalParticle.m_108335_(this.spriteProvider);
                return portalParticle;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class ShardParticle
    extends TextureSheetParticle {
        static final Random RANDOM = new Random();
        private final SpriteSet spriteProvider;

        public ShardParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, SpriteSet spriteProvider) {
            super(clientWorld, d, e, f, g, h, i);
            this.f_172258_ = 0.96f;
            this.f_172259_ = true;
            this.spriteProvider = spriteProvider;
            this.f_107663_ *= 0.75f;
            this.f_107219_ = false;
            this.m_108339_(spriteProvider);
        }

        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107431_;
        }

        public int m_6355_(float tint) {
            float f = ((float)this.f_107224_ + tint) / (float)this.f_107225_;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            int i = super.m_6355_(tint);
            int j = i & 0xFF;
            int k = i >> 16 & 0xFF;
            if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
                j = 240;
            }
            return j | k << 16;
        }

        public void m_5989_() {
            super.m_5989_();
            this.m_108339_(this.spriteProvider);
        }

        @Environment(value=EnvType.CLIENT)
        public static class ShardFactory
        implements ParticleProvider<SimpleParticleType> {
            private final SpriteSet spriteProvider;

            public ShardFactory(FabricSpriteProvider sprites) {
                this.spriteProvider = sprites;
            }

            public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
                ShardParticle shardParticle = new ShardParticle(clientWorld, d, e, f, 0.5 - RANDOM.nextDouble(), h, 0.5 - RANDOM.nextDouble(), this.spriteProvider);
                int rand = clientWorld.f_46441_.m_188503_(4);
                if (rand == 0) {
                    shardParticle.m_107253_(1.0f, 0.796f, 0.9f);
                } else if (rand == 1) {
                    shardParticle.m_107253_(0.392f, 0.278f, 0.619f);
                } else if (rand == 2) {
                    shardParticle.m_107253_(0.65f, 0.47f, 0.945f);
                } else if (rand == 3) {
                    shardParticle.m_107253_(0.784f, 0.564f, 0.941f);
                }
                shardParticle.f_107216_ *= 0.2f;
                if (g == 0.0 && i == 0.0) {
                    shardParticle.f_107215_ *= 0.1f;
                    shardParticle.f_107217_ *= 0.1f;
                }
                shardParticle.m_107257_((int)(8.0 / (clientWorld.f_46441_.m_188500_() * 0.8 + 0.2)));
                return shardParticle;
            }
        }
    }
}

